using UnityEngine;
using TMPro;
using UnityEngine.UI;

public class ScoresTab : SettingsTab
{
    protected override void Awake()
    {
        base.Awake();
        tabName = "SCORES";
        tabOrder = 0;
        
        // Créer le contenu de l'onglet
        CreateContent();
    }
    
    private void CreateContent()
    {
        // Créer un texte de placeholder
        GameObject textObj = new GameObject("PlaceholderText");
        textObj.transform.SetParent(transform, false);
        
        RectTransform textRect = textObj.AddComponent<RectTransform>();
        textRect.anchorMin = Vector2.zero;
        textRect.anchorMax = Vector2.one;
        textRect.offsetMin = new Vector2(40, 40);
        textRect.offsetMax = new Vector2(-40, -40);
        
        TextMeshProUGUI text = textObj.AddComponent<TextMeshProUGUI>();
        text.text = "SCORES\n\nVos scores et statistiques apparaîtront ici.\n\nJouez aux différentes activités pour voir vos résultats !";
        text.fontSize = 20;
        text.color = new Color(0.35f, 0.25f, 0.45f, 1f);
        text.alignment = TextAlignmentOptions.Center;
        text.textWrappingMode = TMPro.TextWrappingModes.Normal;
        text.raycastTarget = false;
    }
}

