# Système de Chargement Unifié - Documentation

## Vue d'ensemble

Le système de chargement unifié a été créé pour résoudre le problème des écrans parasites qui apparaissent pendant le chargement des assets en ligne. Il fournit une expérience utilisateur cohérente avec des écrans de chargement appropriés.

## Composants du système

### 1. LoadingScreenManager (Amélioré)
- **Fichier**: `Scripts/LoadingScreenManager.cs`
- **Rôle**: Gère l'affichage de l'écran de chargement avec animations
- **Fonctionnalités**:
  - Animation de spinner rotatif
  - Animation de points ("Chargement...", "Chargement..", "Chargement.")
  - Transitions en fondu (fade in/out)
  - Gestion de la file d'attente des messages
  - Messages prédéfinis pour différents contextes

### 2. UnifiedLoadingManager
- **Fichier**: `Scripts/UnifiedLoadingManager.cs`
- **Rôle**: Point d'entrée unifié pour toutes les opérations de chargement
- **Fonctionnalités**:
  - Méthodes statiques pour afficher/masquer le chargement
  - Support de différents contextes (jeu, carte, vidéo, menu)
  - Choix entre écran intégré ou scène dédiée
  - Transitions de scènes avec chargement

### 3. LoadingSceneManager
- **Fichier**: `Scripts/LoadingSceneManager.cs`
- **Rôle**: Gère une scène de chargement dédiée pour les cas critiques
- **Fonctionnalités**:
  - Barre de progression
  - Rotation des messages
  - Temps minimum de chargement
  - Chargement asynchrone de scènes

### 4. LoadingSystemInitializer
- **Fichier**: `Scripts/LoadingSystemInitializer.cs`
- **Rôle**: Initialise automatiquement le système dans chaque scène
- **Fonctionnalités**:
  - Création automatique des gestionnaires si manquants
  - Initialisation au démarrage de la scène

## Utilisation

### Méthodes de base

```csharp
// Afficher l'écran de chargement
UnifiedLoadingManager.ShowLoading("Chargement en cours...");

// Afficher avec un contexte spécifique
UnifiedLoadingManager.ShowLoading("Chargement du jeu...", LoadingContext.Game);

// Masquer l'écran de chargement
UnifiedLoadingManager.HideLoading();

// Masquer après un délai
UnifiedLoadingManager.HideLoadingAfterDelay(1.0f);
```

### Transitions de scènes

```csharp
// Charger une scène avec écran de chargement intégré
UnifiedLoadingManager.LoadScene("menu", LoadingContext.Menu);

// Charger avec message personnalisé
UnifiedLoadingManager.LoadScene("game", "Initialisation du jeu...");

// Utiliser la scène de chargement dédiée
UnifiedLoadingManager.UseDedicatedLoadingScene(true);
UnifiedLoadingManager.LoadScene("game", LoadingContext.Game);
```

### Méthodes de convenance

```csharp
// Méthodes spécialisées
UnifiedLoadingManager.LoadGameScene("shooting");
UnifiedLoadingManager.LoadMapScene("map");
UnifiedLoadingManager.LoadVideoScene("video");
UnifiedLoadingManager.LoadMenuScene("menu");
```

## Intégration dans les gestionnaires existants

### GameManager
- Affiche "Chargement de la configuration du jeu..." au début
- Masque l'écran après initialisation complète

### MapManager
- Affiche "Chargement de la carte..." au début
- Masque l'écran après chargement de la configuration

### CalculatorGameManager
- Affiche "Chargement de la calculatrice..." au début
- Masque l'écran après initialisation complète

## Configuration

### Messages prédéfinis
```csharp
public string defaultMessage = "Chargement en cours";
public string gameLoadingMessage = "Chargement du jeu...";
public string mapLoadingMessage = "Chargement de la carte...";
public string videoLoadingMessage = "Chargement de la vidéo...";
public string assetsLoadingMessage = "Chargement des ressources...";
```

### Paramètres d'animation
```csharp
public float dotAnimationSpeed = 0.5f;      // Vitesse des points
public float iconRotationSpeed = 90f;       // Vitesse de rotation du spinner
public float fadeInDuration = 0.3f;         // Durée du fondu d'apparition
public float fadeOutDuration = 0.3f;        // Durée du fondu de disparition
```

## Contextes de chargement

```csharp
public enum LoadingContext
{
    General,    // Chargement général
    Game,       // Chargement de jeu
    Map,        // Chargement de carte
    Video,      // Chargement de vidéo
    Menu        // Retour au menu
}
```

## Scène de chargement dédiée

Pour utiliser une scène de chargement dédiée :

1. Créer une scène nommée "LoadingScene"
2. Ajouter le script `LoadingSceneManager` à un GameObject
3. Configurer l'UI (barre de progression, messages, etc.)
4. Utiliser `UnifiedLoadingManager.UseDedicatedLoadingScene(true)`

## Avantages du système

1. **Cohérence**: Même expérience utilisateur dans tout le jeu
2. **Flexibilité**: Choix entre écran intégré ou scène dédiée
3. **Performance**: Évite les écrans parasites pendant le chargement
4. **Maintenabilité**: Code centralisé et réutilisable
5. **Extensibilité**: Facile d'ajouter de nouveaux contextes

## Dépannage

### L'écran de chargement ne s'affiche pas
- Vérifier que `LoadingScreenManager.Instance` n'est pas null
- S'assurer que le prefab `LoadingScreenCanvas` est présent dans la scène
- Vérifier que `LoadingSystemInitializer` est ajouté à la scène

### Les transitions de scènes ne fonctionnent pas
- Vérifier que `UnifiedLoadingManager.Instance` n'est pas null
- S'assurer que les noms de scènes sont corrects
- Vérifier que les scènes sont ajoutées au Build Settings

### Messages de chargement incorrects
- Vérifier la configuration des messages dans `LoadingScreenManager`
- Utiliser les méthodes de convenance appropriées
- Personnaliser les messages selon le contexte

## Exemple d'utilisation complète

```csharp
public class MyGameManager : MonoBehaviour
{
    void Start()
    {
        StartCoroutine(LoadGameData());
    }
    
    IEnumerator LoadGameData()
    {
        // Afficher l'écran de chargement
        UnifiedLoadingManager.ShowLoading("Chargement des données...", LoadingContext.Game);
        
        // Charger les données
        yield return StartCoroutine(LoadDataFromServer());
        
        // Masquer l'écran de chargement
        UnifiedLoadingManager.HideLoadingAfterDelay(0.5f);
    }
}
```

Ce système garantit que les joueurs ne verront plus d'écrans parasites pendant le chargement des assets en ligne, offrant une expérience utilisateur fluide et professionnelle.
