# 🎮 Système de Jeux de Trous - Guide Complet

**Date** : 24 octobre 2025  
**Statut** : ✅ **OPÉRATIONNEL**  
**Version** : 1.0.0

---

## 📋 Table des Matières

1. [Vue d'Ensemble](#vue-densemble)
2. [Installation Rapide](#installation-rapide)
3. [Configuration JSON](#configuration-json)
4. [Architecture Technique](#architecture-technique)
5. [Utilisation](#utilisation)
6. [Troubleshooting](#troubleshooting)

---

## 🎯 Vue d'Ensemble

Le système de jeux de trous permet de créer des mini-jeux de type "texte à trous" avec des listes déroulantes interactives.

### **Fonctionnalités**
- ✅ Texte avec trous cliquables
- ✅ Listes déroulantes pour chaque trou
- ✅ Validation automatique des réponses
- ✅ Feedback visuel et sonore
- ✅ Support vidéo ET image de fond
- ✅ Configuration complète via JSON
- ✅ Intégration avec le système existant

### **Fichiers Créés**
```
Assets/
├── Scripts/
│   ├── Managers/
│   │   └── TrousGameManager.cs
│   ├── UI/
│   │   └── TrousDropdown.cs
│   └── Editor/
│       └── TrousSceneGenerator.cs
└── StreamingAssets/json/
    ├── Q10J1.json
    ├── Q10J1_image.json
    ├── questions_trous.json
    └── Q10J1_dialogues.json
```

---

## 🚀 Installation Rapide

### **Étape 1 : Créer la Scène**
1. **Unity** : `File → New Scene`
2. **Sauvegarder** : `Assets/Scenes/Trous.unity`

### **Étape 2 : Générer la Hiérarchie**
1. **Menu** : `Tools → Trous Scene → Generate Scene`
2. **Attendre** 2-3 secondes
3. **Sauvegarder** : `Ctrl+S`

### **Étape 3 : Ajouter aux Build Settings**
1. **Menu** : `File → Build Settings`
2. **Cliquer** : `Add Open Scenes`

### **Étape 4 : Tester**
1. **Ouvrir** `levels-config.json`
2. **Vérifier** que Q10J1 est présent
3. **Lancer** depuis une map

---

## 📝 Configuration JSON

### **Structure du Jeu (Q10J1.json)**

#### **Avec Image de Fond**
```json
{
  "gameConfig": {
    "questionsUrl": "questions_trous.json",
    "resolution": { "width": 1920, "height": 1080 },
    "background": {
      "type": "image",
      "imageUrl": "Q10J1_fond.jpg"
    },
    "sounds": {
      "success": "success.wav",
      "fail": "fail.wav"
    },
    "textConfig": {
      "position": { "x": 100, "y": 200 },
      "size": { "width": 1720, "height": 680 },
      "fontSize": 36,
      "fontColor": "#64477f",
      "fontBold": true,
      "alignment": "Left",
      "backgroundColor": "#f5ece5",
      "backgroundAlpha": 0.8,
      "padding": { "top": 20, "bottom": 20, "left": 30, "right": 30 }
    },
    "dropdownConfig": {
      "fontSize": 32,
      "fontColor": "#2c3e50",
      "backgroundColor": "#ffffff",
      "borderColor": "#64477f",
      "borderWidth": 2,
      "itemHeight": 40
    },
    "feedbackMessages": {
      "correctAnswerMessage": "✅ Excellente réponse !",
      "incorrectAnswerMessage": "❌ Mauvaise réponse !",
      "resultMessageColor": "#539d38",
      "incorrectMessageColor": "#d13e48"
    },
    "dialoguesUrl": "Q10J1_dialogues.json"
  }
}
```

#### **Avec Vidéo de Fond**
```json
{
  "gameConfig": {
    "background": {
      "type": "video",
      "videoUrl": "Q10J1_jeu.mp4"
    }
  }
}
```

### **Questions (questions_trous.json)**
```json
{
  "questions": [
    {
      "id": "q1",
      "text": "L'assurance est un système de [TROU1] qui permet de se prémunir contre les [TROU2].",
      "holes": [
        {
          "id": "hole1",
          "position": 45,
          "length": 10,
          "correctAnswer": "protection",
          "options": ["protection", "prévention", "prédiction", "prospection"]
        },
        {
          "id": "hole2",
          "position": 120,
          "length": 7,
          "correctAnswer": "risques",
          "options": ["risques", "dangers", "menaces", "problèmes"]
        }
      ],
      "explanation": "L'assurance protège contre les risques de la vie quotidienne."
    }
  ]
}
```

### **Dialogues (Q10J1_dialogues.json)**
```json
{
  "dialogues": {
    "intro": {
      "speaker": "Narrateur",
      "lines": [
        { "text": "Bienvenue dans ce jeu de trous !", "duration": 3.0 },
        { "text": "Complétez les phrases correctement.", "duration": 3.0 }
      ]
    },
    "success": {
      "speaker": "Narrateur",
      "lines": [
        { "text": "Excellent travail !", "duration": 3.0 }
      ]
    },
    "failure": {
      "speaker": "Narrateur",
      "lines": [
        { "text": "Réessayez, vous pouvez y arriver !", "duration": 3.0 }
      ]
    }
  }
}
```

---

## 🏗️ Architecture Technique

### **Classes Principales**

#### **TrousGameManager.cs**
- Gestion du jeu de trous
- Chargement des configurations
- Création des dropdowns
- Validation des réponses
- Gestion du feedback

#### **TrousDropdown.cs**
- Composant dropdown interactif
- Gestion des options
- Animations d'ouverture/fermeture
- Validation visuelle

#### **TrousSceneGenerator.cs**
- Génération automatique de la scène
- Configuration de la hiérarchie
- Assignation des références

### **Flux de Données**
```
Menu → Map → Zone cliquée → Player (dialogue) 
  → Trous.unity → TrousGameManager 
  → Validation → Feedback → Player (dialogue) → Map
```

### **Hiérarchie Générée**
```
Canvas
├── BackgroundVideo (VideoPlayer)
├── BackgroundImage (Image)
├── TextPanel (ScrollRect)
│   └── Content
│       └── QuestionText (TextMeshProUGUI)
├── DropdownContainer
├── FeedbackPanel
│   ├── FeedbackText
│   └── FeedbackBackgroundImage
└── DropdownPrefab
    ├── ButtonText
    └── DropdownPanel

AudioSource
TrousGameManager
```

---

## 🎮 Utilisation

### **Créer un Nouveau Jeu**

1. **Dupliquer** `Q10J1.json` → `Q10J2.json`
2. **Modifier** :
   - URLs des assets (fond, sons)
   - URL des questions
   - URL des dialogues
3. **Créer** `questions_Q10J2.json` avec vos questions
4. **Créer** `Q10J2_dialogues.json` avec vos dialogues
5. **Ajouter** dans `levels-config.json` :
```json
{
  "id": "Q10J2",
  "title": "Q10J2 Nouveau Jeu",
  "type": "trous",
  "questId": "quete10",
  "isEnabled": true
}
```

### **Personnaliser l'Apparence**

#### **Couleurs**
```json
"textConfig": {
  "fontColor": "#64477f",      // Couleur du texte
  "backgroundColor": "#f5ece5", // Fond du panneau
  "backgroundAlpha": 0.8        // Transparence
}
```

#### **Tailles**
```json
"textConfig": {
  "fontSize": 36,              // Taille du texte
  "position": { "x": 100, "y": 200 },
  "size": { "width": 1720, "height": 680 }
}
```

#### **Dropdowns**
```json
"dropdownConfig": {
  "fontSize": 32,
  "borderColor": "#64477f",
  "itemHeight": 40,
  "maxVisibleItems": 5
}
```

---

## 🐛 Troubleshooting

### **Problème : La Scène ne se Génère pas**
**Solution** :
1. Vérifier que la scène Trous.unity existe et est ouverte
2. Regarder les logs dans la Console
3. Vérifier que tous les scripts compilent sans erreur

### **Problème : Les Dropdowns ne s'Affichent pas**
**Solution** :
1. Vérifier que `dropdownPrefab` est assigné dans TrousGameManager
2. Vérifier que `textContainer` est assigné
3. Vérifier les logs pour les erreurs de création

### **Problème : Le Fond ne s'Affiche pas**

**Pour une Image** :
1. Vérifier que `"type": "image"` est dans le JSON
2. Vérifier que `backgroundImage` est assigné dans TrousGameManager
3. Vérifier que l'objet BackgroundImage est actif

**Pour une Vidéo** :
1. Vérifier que `"type": "video"` est dans le JSON
2. Vérifier que `backgroundVideo` est assigné
3. Vérifier que l'URL de la vidéo est correcte

### **Problème : Les Références ne sont pas Assignées**
**Solution** :
1. Régénérer la scène : `Tools → Trous Scene → Generate Scene`
2. Ou assigner manuellement dans TrousGameManager

---

## 📊 Comparaison Image vs Vidéo

| Critère | Image | Vidéo |
|---------|-------|-------|
| **Taille fichier** | 500KB - 2MB | 5MB - 50MB |
| **Chargement** | Instantané | 1-3 secondes |
| **Performance** | Excellente | Moyenne |
| **Immersion** | Statique | Dynamique |
| **Compatibilité** | 100% | 95% (codecs) |

**Recommandation** : Utilisez des **images** sauf si l'animation est nécessaire.

---

## 🎯 Exemples d'Utilisation

### **Exemple 1 : Jeu Simple**
- 1 question
- 2 trous
- Image de fond
- Feedback basique

### **Exemple 2 : Jeu Complexe**
- 3 questions
- 4 trous par question
- Vidéo de fond
- Feedback détaillé avec explications

### **Exemple 3 : Quiz Thématique**
- 5 questions sur l'assurance
- 3 trous par question
- Images thématiques
- Sons personnalisés

---

## ✅ Checklist de Création

### **Avant de Commencer**
- [ ] Scène Trous.unity créée
- [ ] Hiérarchie générée
- [ ] Scène sauvegardée
- [ ] Ajoutée aux Build Settings

### **Configuration du Jeu**
- [ ] JSON de configuration créé
- [ ] Questions créées
- [ ] Dialogues créés
- [ ] Assets (images/vidéos/sons) préparés
- [ ] Ajouté dans levels-config.json

### **Tests**
- [ ] Chargement de la scène
- [ ] Affichage du fond
- [ ] Affichage des questions
- [ ] Fonctionnement des dropdowns
- [ ] Validation des réponses
- [ ] Affichage du feedback
- [ ] Transitions vers dialogues

---

## 🎉 Résumé

**Le système de jeux de trous est maintenant :**
- ✅ **100% fonctionnel**
- ✅ **Facile à utiliser**
- ✅ **Complètement configurable**
- ✅ **Bien intégré**
- ✅ **Performant**

**Pour créer un nouveau jeu :**
1. Dupliquer les JSONs
2. Modifier les configurations
3. Tester !

**C'est tout ! Le système gère le reste automatiquement ! 🚀**

---

**Besoin d'aide ?** Consultez les exemples fournis dans `Q10J1.json` et `questions_trous.json`.
