mergeInto(LibraryManager.library, {
  // ═══════════════════════════════════════════════════════════════
  // INITIALISATION PRÉCOCE DU LISTENER (AVANT UNITY)
  // Cela permet de capturer les tokens envoyés pendant le chargement
  // ═══════════════════════════════════════════════════════════════
  
  $UJSA_EarlyInit__postset: `
    // Ce code s'exécute dans le navigateur, pas pendant la compilation
    (function() {
      // Vérifier si on est dans une iframe
      var inIframe = window.self !== window.top;
      
      if (!inIframe) {
        console.log('[PostMessage] Pas dans une iframe - listener précoce non installé');
        window.UJSA_InIframe = false;
        return;
      }
      
      console.log('[PostMessage] 🚀 LISTENER PRÉCOCE installé (avant Unity)');
      window.UJSA_InIframe = true;
      window.UJSA_JWT = null;
      window.UJSA_PARENT_ORIGIN = 'https://www.newsassurancespro.com';
      
      // Installer le listener IMMÉDIATEMENT
      if (!window.UJSA_EarlyMessageListener) {
        window.UJSA_EarlyMessageListener = function(event) {
          var parentOrigin = window.UJSA_PARENT_ORIGIN;
          
          // Vérifier l'origin
          if (event.origin !== parentOrigin) {
            console.warn('[PostMessage] ⛔ Message précoce reçu d\\'une origine non autorisée:', event.origin);
            return;
          }
          
          var data = event.data || {};
          
          // Capturer le token AVANT que Unity soit prêt
          if (data.type === 'SET_TOKEN' && data.token) {
            console.log('[PostMessage] 🎯 TOKEN CAPTURÉ AVANT UNITY (longueur:', data.token.length, 'caractères)');
            window.UJSA_JWT = data.token;
          }
        };
        
        window.addEventListener('message', window.UJSA_EarlyMessageListener);
        console.log('[PostMessage] ✓ Listener précoce actif - prêt à recevoir des tokens');
      }
    })();
  `,
  
  $UJSA_EarlyInit: function() {
    // Fonction vide, juste pour déclencher le __postset
  },
  // ─────────────────────────────────────────────────────────────
  //  COMMUNICATION IFRAME via window.postMessage
  //  Entre Unity WebGL et le site parent (newsassurancespro.com)
  // ─────────────────────────────────────────────────────────────

  // Variable globale pour stocker le token JWT
  // window.UJSA_JWT sera accessible depuis Unity
  
  // Configuration de sécurité
  UJSA_PARENT_ORIGIN: 'https://www.newsassurancespro.com',
  
  // Initialiser le listener postMessage (à appeler au démarrage du jeu)
  PostMessage_Init__deps: ['$UJSA_EarlyInit'],
  PostMessage_Init: function() {
    console.log('[PostMessage] ═══════════════════════════════════════════');
    console.log('[PostMessage] Initialisation Unity de la communication iframe');
    console.log('[PostMessage] window.self:', window.self);
    console.log('[PostMessage] window.top:', window.top);
    
    // Vérifier si on est dans une iframe
    var inIframe = window.self !== window.top;
    
    if (!inIframe) {
      console.log('[PostMessage] ⚠ Pas dans une iframe - communication postMessage désactivée');
      window.UJSA_InIframe = false;
      return 0;
    }
    
    console.log('[PostMessage] ✓ Détecté dans une iframe - activation de la communication');
    console.log('[PostMessage] Origin autorisé:', Module.UJSA_PARENT_ORIGIN || window.UJSA_PARENT_ORIGIN || 'https://www.newsassurancespro.com');
    
    // Vérifier si un token a déjà été capturé par le listener précoce
    if (window.UJSA_JWT) {
      console.log('[PostMessage] 🎁 TOKEN DÉJÀ PRÉSENT (capturé pendant le chargement)');
      console.log('[PostMessage]    Longueur:', window.UJSA_JWT.length, 'caractères');
    } else {
      console.log('[PostMessage] Aucun token capturé pendant le chargement');
    }
    
    window.UJSA_InIframe = true;
    
    // Listener pour les messages du parent (remplace le listener précoce)
    // Note: Le listener précoce a déjà pu capturer des tokens
    if (!window.UJSA_MessageListener) {
      // Supprimer le listener précoce s'il existe
      if (window.UJSA_EarlyMessageListener) {
        console.log('[PostMessage] Remplacement du listener précoce par le listener Unity');
        window.removeEventListener('message', window.UJSA_EarlyMessageListener);
        window.UJSA_EarlyMessageListener = null;
      }
      
      window.UJSA_MessageListener = function(event) {
        console.log('[PostMessage] ───────────────────────────────────────');
        console.log('[PostMessage] 📨 Message reçu !');
        console.log('[PostMessage]    Origin:', event.origin);
        console.log('[PostMessage]    Data:', event.data);
        
        // SÉCURITÉ : Vérifier l'origin du parent
        var parentOrigin = Module.UJSA_PARENT_ORIGIN || 'https://www.newsassurancespro.com';
        
        console.log('[PostMessage]    Origin attendu:', parentOrigin);
        
        if (event.origin !== parentOrigin) {
          console.warn('[PostMessage] ⛔ Message reçu d\'une origine non autorisée:', event.origin);
          console.warn('[PostMessage]    Pour accepter cette origine, appelez PostMessage_SetParentOrigin("' + event.origin + '")');
          return;
        }
        
        var data = event.data || {};
        
        console.log('[PostMessage] ✓ Origin validé, traitement du message...');
        
        // Traiter le message SET_TOKEN
        if (data.type === 'SET_TOKEN' && data.token) {
          console.log('[PostMessage] ✓ Type: SET_TOKEN détecté');
          console.log('[PostMessage] ✓ Token JWT reçu (longueur:', data.token.length, 'caractères)');
          window.UJSA_JWT = data.token;
          console.log('[PostMessage] ✓ Token stocké dans window.UJSA_JWT');
          
          // Notifier Unity qu'un token a été reçu (optionnel)
          try {
            if (typeof SendMessage !== 'undefined') {
              console.log('[PostMessage] Tentative d\'envoi à Unity via SendMessage...');
              SendMessage('LoginManager', 'OnTokenReceived', data.token);
              console.log('[PostMessage] ✓ SendMessage envoyé à Unity');
            } else {
              console.log('[PostMessage] ⚠ SendMessage non disponible (Unity pas encore prêt)');
            }
          } catch (e) {
            console.log('[PostMessage] ⚠ Erreur SendMessage:', e.message);
          }
        } else {
          console.warn('[PostMessage] ⚠ Type de message non géré ou données manquantes');
          console.warn('[PostMessage]    Type reçu:', data.type);
          console.warn('[PostMessage]    Token présent:', !!data.token);
        }
      };
      
      window.addEventListener('message', window.UJSA_MessageListener);
      console.log('[PostMessage] ✓ Listener installé pour recevoir les messages du parent');
      console.log('[PostMessage] ═══════════════════════════════════════════');
    }
    
    return 1;
    
    return 1;
  },
  
  // Vérifier si on est dans une iframe
  PostMessage_IsInIframe: function() {
    return window.UJSA_InIframe ? 1 : 0;
  },
  
  // Récupérer le token JWT stocké (retourne 1 si un token existe, 0 sinon)
  PostMessage_GetToken: function(bufferPtr, bufferSize) {
    console.log('[PostMessage] GetToken appelé');
    console.log('[PostMessage]    window.UJSA_JWT:', window.UJSA_JWT ? 'présent (' + window.UJSA_JWT.length + ' chars)' : 'null');
    
    if (!window.UJSA_JWT) {
      console.log('[PostMessage]    Retour: 0 (pas de token)');
      return 0;
    }
    
    var token = window.UJSA_JWT;
    stringToUTF8(token, bufferPtr, bufferSize);
    console.log('[PostMessage]    Retour: 1 (token copié dans le buffer)');
    return 1;
  },
  
  // Vérifier si un token JWT existe
  PostMessage_HasToken: function() {
    var hasToken = (window.UJSA_JWT && window.UJSA_JWT.length > 0) ? 1 : 0;
    console.log('[PostMessage] HasToken appelé, retour:', hasToken);
    return hasToken;
  },
  
  // Envoyer un message UJSA_LOGIN au parent après connexion réussie
  PostMessage_NotifyLogin: function(tokenPtr) {
    // Vérifier si on est dans une iframe
    if (!window.UJSA_InIframe) {
      console.log('[PostMessage] ⚠ Pas dans une iframe - notification de login annulée');
      return 0;
    }
    
    var token = UTF8ToString(tokenPtr || 0) || '';
    
    if (!token) {
      console.warn('[PostMessage] ⚠ Token vide - notification de login annulée');
      return 0;
    }
    
    var parentOrigin = Module.UJSA_PARENT_ORIGIN || 'https://www.newsassurancespro.com';
    
    var message = {
      type: 'UJSA_LOGIN',
      token: token
    };
    
    console.log('[PostMessage] 📤 Envoi de UJSA_LOGIN au parent:', parentOrigin);
    
    try {
      window.parent.postMessage(message, parentOrigin);
      console.log('[PostMessage] ✓ Message UJSA_LOGIN envoyé avec succès');
      return 1;
    } catch (e) {
      console.error('[PostMessage] ⛔ Erreur lors de l\'envoi du message:', e);
      return 0;
    }
  },
  
  // Nettoyer le token (déconnexion)
  PostMessage_ClearToken: function() {
    console.log('[PostMessage] 🗑 Suppression du token JWT');
    window.UJSA_JWT = null;
  },
  
  // Définir manuellement le token (pour debug ou cas particuliers)
  PostMessage_SetToken: function(tokenPtr) {
    var token = UTF8ToString(tokenPtr || 0) || '';
    if (token) {
      console.log('[PostMessage] 📝 Token JWT défini manuellement');
      window.UJSA_JWT = token;
      return 1;
    }
    return 0;
  },
  
  // Changer l'origin autorisé du parent (pour environnement de dev)
  PostMessage_SetParentOrigin: function(originPtr) {
    var origin = UTF8ToString(originPtr || 0) || '';
    if (origin) {
      console.log('[PostMessage] 🔧 Origin du parent changé:', origin);
      Module.UJSA_PARENT_ORIGIN = origin;
      return 1;
    }
    return 0;
  }
});

