using UnityEngine;
using UnityEngine.UI;
using TMPro;

/// <summary>
/// Script de démonstration pour tester le système de chargement unifié
/// À utiliser dans une scène de test
/// </summary>
public class LoadingSystemDemo : MonoBehaviour
{
    [Header("UI References")]
    [SerializeField] private Button testGameLoadingButton;
    [SerializeField] private Button testMapLoadingButton;
    [SerializeField] private Button testVideoLoadingButton;
    [SerializeField] private Button testCustomLoadingButton;
    [SerializeField] private Button testHideLoadingButton;
    [SerializeField] private Button testSceneTransitionButton;
    [SerializeField] private TMP_InputField customMessageInput;
    [SerializeField] private TMP_InputField sceneNameInput;
    
    [Header("Test Configuration")]
    [SerializeField] private string testSceneName = "menu";
    [SerializeField] private float testLoadingDuration = 3.0f;
    
    void Start()
    {
        SetupButtons();
    }
    
    void SetupButtons()
    {
        if (testGameLoadingButton != null)
        {
            testGameLoadingButton.onClick.AddListener(TestGameLoading);
        }
        
        if (testMapLoadingButton != null)
        {
            testMapLoadingButton.onClick.AddListener(TestMapLoading);
        }
        
        if (testVideoLoadingButton != null)
        {
            testVideoLoadingButton.onClick.AddListener(TestVideoLoading);
        }
        
        if (testCustomLoadingButton != null)
        {
            testCustomLoadingButton.onClick.AddListener(TestCustomLoading);
        }
        
        if (testHideLoadingButton != null)
        {
            testHideLoadingButton.onClick.AddListener(TestHideLoading);
        }
        
        if (testSceneTransitionButton != null)
        {
            testSceneTransitionButton.onClick.AddListener(TestSceneTransition);
        }
    }
    
    void TestGameLoading()
    {
        Debug.Log("[LoadingSystemDemo] Test du chargement de jeu");
        UnifiedLoadingManager.ShowLoading("Test de chargement du jeu...", LoadingContext.Game);
        
        // Simuler un chargement
        StartCoroutine(SimulateLoading());
    }
    
    void TestMapLoading()
    {
        Debug.Log("[LoadingSystemDemo] Test du chargement de carte");
        UnifiedLoadingManager.ShowLoading("Test de chargement de la carte...", LoadingContext.Map);
        
        // Simuler un chargement
        StartCoroutine(SimulateLoading());
    }
    
    void TestVideoLoading()
    {
        Debug.Log("[LoadingSystemDemo] Test du chargement de vidéo");
        UnifiedLoadingManager.ShowLoading("Test de chargement de la vidéo...", LoadingContext.Video);
        
        // Simuler un chargement
        StartCoroutine(SimulateLoading());
    }
    
    void TestCustomLoading()
    {
        string customMessage = customMessageInput != null ? customMessageInput.text : "Message personnalisé...";
        if (string.IsNullOrEmpty(customMessage))
        {
            customMessage = "Chargement personnalisé...";
        }
        
        Debug.Log($"[LoadingSystemDemo] Test du chargement personnalisé: {customMessage}");
        UnifiedLoadingManager.ShowLoading(customMessage);
        
        // Simuler un chargement
        StartCoroutine(SimulateLoading());
    }
    
    void TestHideLoading()
    {
        Debug.Log("[LoadingSystemDemo] Test de la disparition du chargement");
        UnifiedLoadingManager.HideLoading();
    }
    
    void TestSceneTransition()
    {
        string sceneName = sceneNameInput != null ? sceneNameInput.text : testSceneName;
        if (string.IsNullOrEmpty(sceneName))
        {
            sceneName = testSceneName;
        }
        
        Debug.Log($"[LoadingSystemDemo] Test de transition vers la scène: {sceneName}");
        UnifiedLoadingManager.LoadScene(sceneName, LoadingContext.General);
    }
    
    System.Collections.IEnumerator SimulateLoading()
    {
        yield return new WaitForSeconds(testLoadingDuration);
        UnifiedLoadingManager.HideLoading();
        Debug.Log("[LoadingSystemDemo] Simulation de chargement terminée");
    }
    
    void OnGUI()
    {
        if (UnifiedLoadingManager.Instance != null)
        {
            GUI.Label(new Rect(10, 10, 300, 20), $"Système de chargement: ACTIF");
            bool isLoading = LoadingScreenManager.Instance != null && LoadingScreenManager.Instance.IsLoading;
            GUI.Label(new Rect(10, 30, 300, 20), $"En cours de chargement: {isLoading}");
        }
        else
        {
            GUI.Label(new Rect(10, 10, 300, 20), $"Système de chargement: INACTIF");
        }
    }
}
