using System;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class MainSceneConfigWrapper
{
    public MainSceneConfig mainSceneConfig;
}

// Structure pour la réponse API
[Serializable]
public class ApiMainSceneResponse
{
    public string status;
    public string message;
    public ApiMainSceneData data;
}

[Serializable]
public class ApiMainSceneData
{
    public ApiMainSceneBackgroundConfig background;
    public List<ApiMainSceneQuest> quests;
}

[Serializable]
public class ApiMainSceneBackgroundConfig
{
    public string type; // "image" ou "video"
    public string url;
}

[Serializable]
public class ApiMainSceneQuest
{
    public int id;
    public string title;
    public string description;
    public string trailer_url;
    public string duration;
    public string visibility;
    public string status; // "available", "locked", "completed", etc.
    public List<ApiMainSceneTraining> trainings;
    public bool has_access;
    public string sprite_url;
    public Vector2Data sprite_position;
    public Vector2Data sprite_size;
    public string tooltip_text;
    public List<QuestUserProgress> user; // Progression de l'utilisateur par difficulté
}

[Serializable]
public class ApiMainSceneTraining
{
    public string title;
    public string url;
}

// Structure pour le format fichier local (format interne)
[Serializable]
public class MainSceneConfig
{
    public MainSceneBackgroundConfig background;
    public List<MainSceneMapEntry> mapEntries;
    public List<Quest> quests; // Données complètes des quêtes depuis l'API
}

[Serializable]
public class MainSceneBackgroundConfig
{
    public string type; // "image" ou "video"
    public string url;
}

[Serializable]
public class MainSceneMapEntry
{
    public string id;
    public string mapId; // ID de la map à charger (ex: "map-Q9")
    public int questId; // ID de la quest depuis l'API (pour charger la map via l'API)
    public string spriteUrl; // URL de l'image du sprite
    public Vector2Data position; // Position du sprite sur le background
    public Vector2Data size; // Taille du sprite
    public string tooltipText; // Texte optionnel pour l'info-bulle
    public int sortingOrder; // Ordre de tri pour l'affichage (optionnel)
    public bool has_access; // L'utilisateur a-t-il accès à cette quête ?
    public string status; // Statut de la quête ("available", "locked", "completed", etc.)
}

