# 🔧 Guide : Configurer les Scènes dans le Build

## 🎯 Problème

L'erreur `Scene 'Map' couldn't be loaded because it has not been added to the active build profile` signifie que Unity ne peut pas charger une scène qui n'est pas dans le **Build Settings**.

---

## 📋 Étapes à Suivre

### 1. Ouvrir les Build Settings
1. Dans Unity, menu **File** → **Build Profiles** (ou **Build Settings** dans les anciennes versions)
2. OU raccourci : **Ctrl + Shift + B** (Windows) / **Cmd + Shift + B** (Mac)

### 2. Ajouter les Scènes au Build

Vous devez ajouter **toutes les scènes** utilisées dans votre jeu :

#### Scènes Essentielles à Ajouter :
1. **menu** (ou **Menu**) - Scène principale du menu
2. **Map** - Scène de la carte interactive
3. **Player** - Scène pour les dialogues et le jeu

#### Comment Ajouter une Scène :
1. Dans le dossier **Assets/Scenes**, trouvez la scène
2. **Glissez-déposez** la scène dans la fenêtre **Build Settings** → **Scenes In Build**
3. OU cliquez sur **Add Open Scenes** si la scène est déjà ouverte

### 3. Ordre des Scènes

L'ordre est important ! Voici l'ordre recommandé :

```
Scenes In Build:
0. menu        ✓ [index 0 - scène de démarrage]
1. Map         ✓ [index 1]
2. Player      ✓ [index 2]
```

**Note** : La scène avec l'index 0 est celle qui se lance au démarrage du jeu.

### 4. Vérifier les Noms

⚠️ **IMPORTANT** : Les noms de scènes doivent correspondre **exactement** (majuscules/minuscules) :

Dans votre code, vous utilisez :
- `SceneManager.LoadScene("menu")`
- `SceneManager.LoadScene("Map")`
- `SceneManager.LoadScene("Player")`

Les fichiers de scène doivent s'appeler :
- `Assets/Scenes/menu.unity` (ou `Menu.unity`)
- `Assets/Scenes/Map.unity`
- `Assets/Scenes/Player.unity`

### 5. Corriger les Noms de Fichiers (si nécessaire)

Si vos fichiers ont des noms différents :

**Option A : Renommer les fichiers**
1. Dans le **Project**, dossier **Scenes**
2. Clic droit sur la scène → **Rename**
3. Renommez pour correspondre au code (ex: `menu.unity`)

**Option B : Modifier le code**
Si vous préférez garder les noms actuels des fichiers, vous pouvez ajuster le code dans `LevelManager.cs` :
```csharp
// Ligne 412
SceneManager.LoadScene(returnToScene);
```

---

## ✅ Vérification

### 1. Vérifier que toutes les scènes sont listées
Dans **Build Settings** → **Scenes In Build**, vous devez voir :
```
☑ menu        (index 0)
☑ Map         (index 1)
☑ Player      (index 2)
```

### 2. Tester
1. Lancez la scène **menu**
2. Cliquez sur une carte de niveau
3. Jouez au jeu
4. Terminez le dialogue de fin

**Résultat attendu** :
```
[LevelManager] Scène d'origine: menu
[LevelManager] Retour à la scène: menu
[LevelManager] Retour au menu - pas de gestion de steps
```

✅ **Vous devez retourner au menu !**

---

## 🔍 Si le Problème Persiste

### Problème : "Scene 'menu' couldn't be loaded"

**Cause** : Différence de casse (majuscules/minuscules)

**Solution** : Vérifiez que le nom dans le code correspond **exactement** au nom du fichier :
- Fichier : `menu.unity` → Code : `"menu"`
- Fichier : `Menu.unity` → Code : `"Menu"`

### Problème : "Scene not found"

**Cause** : La scène n'existe pas ou est dans un autre dossier

**Solution** :
1. Vérifiez que le fichier existe dans `Assets/Scenes/`
2. Si la scène est ailleurs, ajustez le chemin ou déplacez-la

---

## 📝 Note Technique

Le système sauvegarde maintenant la scène d'origine dans `PlayerPrefs` :
```csharp
PlayerPrefs.SetString("ReturnToScene", currentScene);
```

Quand le jeu se termine, il lit cette valeur et retourne à la bonne scène :
```csharp
string returnToScene = PlayerPrefs.GetString("ReturnToScene", "menu");
SceneManager.LoadScene(returnToScene);
```

Si `ReturnToScene` n'est pas défini, la valeur par défaut est **"menu"**, donc le jeu retournera toujours au menu en cas de problème.

---

## 🎯 Résultat Final

Une fois configuré correctement :
1. ✅ Lancer un jeu depuis le **Menu** → Retour au **Menu** après
2. ✅ Lancer un jeu depuis la **Map** → Retour à la **Map** après
3. ✅ Plus d'erreur "Scene couldn't be loaded"
4. ✅ Le système se souvient d'où vous venez

**Le flow est maintenant cohérent !** 🎉

