# Script pour réinitialiser et tester l'intro de la map
# Utilisation: .\RESET_ET_TEST_INTRO.ps1

Write-Host ""
Write-Host "=========================================" -ForegroundColor Cyan
Write-Host "  RESET INTRO MAP Q1" -ForegroundColor Cyan
Write-Host "=========================================" -ForegroundColor Cyan
Write-Host ""

# Chemin du registre pour les PlayerPrefs Unity
$companyName = "DefaultCompany"  # Remplacer si nécessaire
$productName = "UnJourSansAssurance"  # Remplacer si nécessaire
$registryPath = "HKCU:\Software\$companyName\$productName"

Write-Host "Recherche des PlayerPrefs..." -ForegroundColor Yellow

if (Test-Path $registryPath) {
    Write-Host "PlayerPrefs trouves dans: $registryPath" -ForegroundColor Green
    Write-Host ""
    
    # Lister les clés actuelles liées à la map
    Write-Host "Cles actuelles liees a map-Q1:" -ForegroundColor Cyan
    Get-ItemProperty $registryPath | Select-Object -Property IntroWatched_map-Q1, CurrentStepId_map-Q1, NextStepId_map-Q1 | Format-List
    
    Write-Host ""
    Write-Host "Suppression des cles..." -ForegroundColor Yellow
    
    # Supprimer les clés
    try {
        Remove-ItemProperty -Path $registryPath -Name "IntroWatched_map-Q1" -ErrorAction SilentlyContinue
        Remove-ItemProperty -Path $registryPath -Name "CurrentStepId_map-Q1" -ErrorAction SilentlyContinue
        Remove-ItemProperty -Path $registryPath -Name "NextStepId_map-Q1" -ErrorAction SilentlyContinue
        
        Write-Host ""
        Write-Host "=========================================" -ForegroundColor Green
        Write-Host "  RESET TERMINE !" -ForegroundColor Green
        Write-Host "=========================================" -ForegroundColor Green
        Write-Host ""
        Write-Host "Les cles suivantes ont ete supprimees:" -ForegroundColor White
        Write-Host "  - IntroWatched_map-Q1" -ForegroundColor Gray
        Write-Host "  - CurrentStepId_map-Q1" -ForegroundColor Gray
        Write-Host "  - NextStepId_map-Q1" -ForegroundColor Gray
        Write-Host ""
        Write-Host "Vous pouvez maintenant tester l'intro:" -ForegroundColor Cyan
        Write-Host "  1. Lancez Unity" -ForegroundColor White
        Write-Host "  2. Lancez le jeu" -ForegroundColor White
        Write-Host "  3. Allez sur la Map Q1" -ForegroundColor White
        Write-Host "  4. L'intro video devrait se jouer !" -ForegroundColor Yellow
        Write-Host ""
    }
    catch {
        Write-Host "Erreur lors de la suppression: $_" -ForegroundColor Red
    }
}
else {
    Write-Host "PlayerPrefs non trouves dans: $registryPath" -ForegroundColor Red
    Write-Host ""
    Write-Host "Essayez de:" -ForegroundColor Yellow
    Write-Host "  1. Lancer le jeu une fois dans Unity" -ForegroundColor White
    Write-Host "  2. Puis relancer ce script" -ForegroundColor White
    Write-Host ""
}

Write-Host "=========================================" -ForegroundColor Cyan
Write-Host ""

