using System;
using UnityEngine;

/// <summary>
/// Petit utilitaire pour obtenir des logs ciblés (et activables) sur les dialogues.
/// Objectif: éviter le spam et capturer UNE stacktrace utile quand le cadre disparaît.
/// </summary>
public static class DialogueDebugLog
{
    // Toggle runtime (F10 dans SubtitleManager)
    public static bool Enabled = false;

    // Si true: inclure Environment.StackTrace dans les logs critiques
    public static bool IncludeStackTrace = true;

    public static void Info(string msg)
    {
        if (!Enabled) return;
        Debug.Log(msg);
    }

    public static void Warn(string msg)
    {
        if (!Enabled) return;
        Debug.LogWarning(msg);
    }

    public static void Critical(string msg)
    {
        if (!Enabled) return;
        if (IncludeStackTrace)
        {
            Debug.LogWarning(msg + "\n--- STACKTRACE ---\n" + Environment.StackTrace);
        }
        else
        {
            Debug.LogWarning(msg);
        }
    }
}


