using UnityEngine;

/// <summary>
/// Script simple pour configurer la scène shooting.
/// Le GameManager détecte automatiquement le ShootingGameLayout s'il existe.
/// Ce script sert principalement à créer le layout avec la bonne configuration.
/// </summary>
public class ShootingSceneSetup : MonoBehaviour
{
    [Header("Configuration")]
    [Tooltip("URL de l'image de fond principale")]
    [SerializeField] private string backgroundImageUrl = "https://ujsa.studioplc.fr/datas/images/main_background.jpg";
    
    [Header("Debug")]
    [SerializeField] private bool showDebugLogs = true;
    
    private ShootingGameLayout layoutManager;
    
    void Awake()
    {
        // Chercher ou créer le layout
        layoutManager = FindFirstObjectByType<ShootingGameLayout>();
        
        if (layoutManager == null)
        {
            // Créer le layout s'il n'existe pas
            Canvas mainCanvas = FindFirstObjectByType<Canvas>();
            if (mainCanvas != null)
            {
                GameObject layoutObj = new GameObject("ShootingGameLayout");
                layoutObj.transform.SetParent(mainCanvas.transform, false);
                layoutManager = layoutObj.AddComponent<ShootingGameLayout>();
                
                if (showDebugLogs)
                    Debug.Log("[ShootingSceneSetup] Layout créé automatiquement");
            }
            else
            {
                Debug.LogError("[ShootingSceneSetup] Pas de Canvas trouvé!");
            }
        }
        else
        {
            if (showDebugLogs)
                Debug.Log("[ShootingSceneSetup] Layout existant détecté");
        }
    }
    
    void Start()
    {
        // Configurer l'URL de l'image de fond
        if (layoutManager != null && !string.IsNullOrEmpty(backgroundImageUrl))
        {
            layoutManager.SetBackgroundImageUrl(backgroundImageUrl);
            
            if (showDebugLogs)
                Debug.Log($"[ShootingSceneSetup] Image de fond configurée: {backgroundImageUrl}");
        }
    }
}
