using UnityEngine;

/// <summary>
/// Script d'initialisation pour le système de chargement unifié
/// À placer dans chaque scène pour s'assurer que le système est disponible
/// </summary>
public class LoadingSystemInitializer : MonoBehaviour
{
    [Header("Configuration")]
    [SerializeField] private bool initializeOnAwake = true;
    [SerializeField] private bool createLoadingScreenIfMissing = true;
    
    void Awake()
    {
        if (initializeOnAwake)
        {
            InitializeLoadingSystem();
        }
    }
    
    void Start()
    {
        if (!initializeOnAwake)
        {
            InitializeLoadingSystem();
        }
    }
    
    void InitializeLoadingSystem()
    {
        // Vérifier si UnifiedLoadingManager existe
        if (UnifiedLoadingManager.Instance == null)
        {
            Debug.LogWarning("[LoadingSystemInitializer] UnifiedLoadingManager non trouvé - création d'un instance temporaire");
            
            // Créer un GameObject temporaire avec UnifiedLoadingManager
            GameObject loadingManagerGO = new GameObject("UnifiedLoadingManager");
            loadingManagerGO.AddComponent<UnifiedLoadingManager>();
            DontDestroyOnLoad(loadingManagerGO);
        }
        
        // Vérifier si LoadingScreenManager existe
        if (LoadingScreenManager.Instance == null && createLoadingScreenIfMissing)
        {
            // Créer un GameObject temporaire avec LoadingScreenManager si nécessaire
            GameObject loadingScreenGO = new GameObject("LoadingScreenManager");
            loadingScreenGO.AddComponent<LoadingScreenManager>();
            DontDestroyOnLoad(loadingScreenGO);
        }
        
        Debug.Log("[LoadingSystemInitializer] Système de chargement initialisé");
    }
    
    /// <summary>
    /// Méthode publique pour initialiser manuellement le système
    /// </summary>
    public void ManualInitialize()
    {
        InitializeLoadingSystem();
    }
}
