using System.Collections.Generic;
using UnityEngine;

/// <summary>
/// Classes UNIQUEMENT pour la calculatrice - réutilise vos classes existantes
/// </summary>

[System.Serializable]
public class CalculatorGameDataWrapper
{
    public GameConfig gameConfig;  // Utilise votre GameConfig existant
    public List<CalculatorQuestionData> questions;  // Questions spécifiques calculatrice
}

[System.Serializable]
public class CalculatorQuestionData
{
    public int id;
    public string question;
    public float correctAnswerMin;
    public float correctAnswerMax;
    public string explanation;
    public int points;
}

// Extensions pour votre GameConfig existant - seulement si pas déjà présentes
[System.Serializable]
public class CalculatorDisplayConfig
{
    public Vector2 position;
    public Vector2 size;
    public Vector2 displayPosition;
    public Vector2 displaySize;
    public string displayBackgroundColor;
    public string displayTextColor;
    public int displayTextSize;
}

[System.Serializable]
public class CalculatorButtonData
{
    public string buttonId;
    public string buttonType; // "number", "delete", "validate"
    public string value;
    public Vector2 position;
    public Vector2 size;
}