using System.Collections.Generic;
using UnityEngine;

/// <summary>
/// Possède des objets Unity créés runtime (Texture2D, Sprite, etc.) et les détruit en OnDestroy.
/// Utile pour éviter les fuites de mémoire (notamment WebGL / abort("OOM")).
/// </summary>
public sealed class RuntimeUnityObjectOwner : MonoBehaviour
{
    private readonly List<Object> owned = new List<Object>(4);

    /// <summary>
    /// Déclare la propriété d'un objet Unity (sera Destroy() en OnDestroy).
    /// </summary>
    public void Own(Object obj)
    {
        if (obj == null) return;
        owned.Add(obj);
    }

    private void OnDestroy()
    {
        // Détruire en ordre inverse pour limiter les surprises (Sprite peut référencer Texture2D).
        for (int i = owned.Count - 1; i >= 0; i--)
        {
            var obj = owned[i];
            if (obj != null) Destroy(obj);
        }
        owned.Clear();
    }
}


